const scroll = new LocomotiveScroll({
  el: document.querySelector('[data-scroll-container]'),
  smooth: true,
  getDirection: true,
  getSpeed: true
});

scroll.on('scroll', function (obj) {
  const header = document.querySelector(".header");
  var logo = document.querySelector(".header__logo");
  var bloccoFisso = document.querySelector("#blocco-fisso");

  


  // Aggiungi la classe "header-hyde" all'header quando l'utente scorre verso il basso di almeno 400px
  if (obj.scroll.y > 400 && obj.direction == 'down') {
    header.classList.add("header-hyde");
  } else {
    header.classList.remove("header-hyde");
  }

  
});

$(document).ready(function() {
  // Nascondi il blocco fisso all'avvio dello script
  $('#blocco-fisso').addClass('blocco-fisso-hidden');

  // Aggiungi l'evento click all'elemento con id #menuImg per aprire e chiudere il blocco fisso
  $("#menuImg").on('click', function() {
      var bloccoFisso = $("#blocco-fisso");
      if (bloccoFisso.hasClass("blocco-fisso-hidden")) {
          bloccoFisso.fadeTo(500, 1).removeClass("blocco-fisso-hidden");
      } else {
          bloccoFisso.fadeTo(500, 0).addClass("blocco-fisso-hidden");
      }
  });

  // Aggiungi l'evento click a tutto il documento per nascondere il blocco fisso quando si clicca in qualsiasi punto
  $(document).on('click', function(event) {
      var bloccoFisso = $("#blocco-fisso");
      if (!bloccoFisso.is(event.target) && bloccoFisso.has(event.target).length === 0 && !$("#menuImg").is(event.target) && $("#menuImg").has(event.target).length === 0) {
          bloccoFisso.fadeTo(500, 0).addClass("blocco-fisso-hidden");
      }
  });

  // Aggiungi l'evento click al menu icon per aprire e chiudere il menu
  $(".header__icon").on('click', function() {
      $(".header__menu").toggleClass("header__menu--open");
  });

  // Aggiungi l'effetto di scorrimento morbido a tutti i link che puntano ad un ID interno sulla stessa pagina
  $('a[href^="#"]').on('click', function(event) {
      // Impedisci il comportamento predefinito del link
      event.preventDefault();

      // Ottieni l'ID della sezione a cui si vuole accedere
      var target = this.hash;

      // Calcola la posizione della sezione
      var $target = $(target);
      var offset = $target.offset().top;

      // Aggiungi l'effetto di scorrimento morbido con scrollTo()
      scroll.scrollTo(offset);

      // Chiudi il menu se l'utente clicca su un link
      $(".header__menu").removeClass("header__menu--open");
  });

  const mediaQuery = window.matchMedia('(max-width: 1680px)');

  function handleMediaQuery(mediaQuery) {
      const title = document.querySelector('.headline-max');
      if (mediaQuery.matches) {
          title.setAttribute('data-scroll-speed', '45');
      } else {
          title.setAttribute('data-scroll-speed', '15');
      }
  }

  handleMediaQuery(mediaQuery);
  mediaQuery.addListener(handleMediaQuery);







  
});










